<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template name="CreateHelpDoc">

		<!-- NAVBAR -->
		<xsl:if test="$navbar_param">
			<xsl:call-template name="HelpNavBar">
				<xsl:with-param name="header" select="'true'"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<hr/>

		<center>
		<h1>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'how'"></xsl:with-param>
		</xsl:call-template>
		</h1>
		</center>
		
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'intro'"></xsl:with-param>
		</xsl:call-template>

		<h3><xsl:value-of select="$gOverview"></xsl:value-of></h3>
		<blockquote>
		<p/>
		<xsl:variable name="olink">
			<xsl:text disable-output-escaping="yes">&lt;a href= "overview-summary.html"&gt;</xsl:text><xsl:value-of select="$gOverview"></xsl:value-of><xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text> 
		</xsl:variable>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'overviewdoc'"></xsl:with-param>
			<xsl:with-param name="p1" select="$olink"></xsl:with-param>
		</xsl:call-template>
		
		</blockquote>

		<h3><xsl:value-of select="$gPackage"></xsl:value-of></h3>
		<blockquote>
		<p/>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'packagedoc'"></xsl:with-param>
		</xsl:call-template>

		<ul>
		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'liInterfaces'"></xsl:with-param>
		</xsl:call-template>
		</li>
		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'liClasses'"></xsl:with-param>
		</xsl:call-template>
		</li>
		<li>...</li>
		</ul>
		</blockquote>

		<h3><xsl:value-of select="$gClass"></xsl:value-of></h3>
		<blockquote>
		<p/>

		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'classdoc'"></xsl:with-param>
		</xsl:call-template>

		<ul>
		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'li_class_inheritance_diagram'"></xsl:with-param>
		</xsl:call-template>
		</li>
		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'li_direct_subclasses'"></xsl:with-param>
		</xsl:call-template>
		</li>
		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'li_all_known_subinterfaces'"></xsl:with-param>
		</xsl:call-template>
		</li>
		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'li_all_known_implementing_classes'"></xsl:with-param>
		</xsl:call-template>
		</li>
		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'li_class_declaration'"></xsl:with-param>
		</xsl:call-template>
		</li>
		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'li_class_description'"></xsl:with-param>
		</xsl:call-template>
		</li>
		<p/>

		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'li_inner_class_summary'"></xsl:with-param>
		</xsl:call-template>
		</li>
		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'li_field_summary'"></xsl:with-param>
		</xsl:call-template>
		</li>
		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'li_constructor_summary'"></xsl:with-param>
		</xsl:call-template>
		</li>
		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'li_destructor_summary'"></xsl:with-param>
		</xsl:call-template>
		</li>
		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'li_method_summary'"></xsl:with-param>
		</xsl:call-template>
		</li>
		<p/>

		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'li_field_detail'"></xsl:with-param>
		</xsl:call-template>
		</li>
		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'li_constructor_detail'"></xsl:with-param>
		</xsl:call-template>
		</li>
		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'li_destructor_detail'"></xsl:with-param>
		</xsl:call-template>
		</li>
		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'li_method_detail'"></xsl:with-param>
		</xsl:call-template>
		</li>
		</ul>

		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'classdocdescr'"></xsl:with-param>
		</xsl:call-template>
		</blockquote>

		<h3><xsl:value-of select="$gTree"></xsl:value-of></h3>
		<blockquote>
		<xsl:variable name="tlink">
			<xsl:text disable-output-escaping="yes">&lt;a href= "overview-tree.html"&gt;</xsl:text><xsl:value-of select="$gTree"></xsl:value-of><xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text> 
		</xsl:variable>
		
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'treedoc'"></xsl:with-param>
			<xsl:with-param name="p1" select="$tlink"></xsl:with-param>
		</xsl:call-template>
		
		
		<ul>
		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'li_tree1'"></xsl:with-param>
		</xsl:call-template>
		</li>
		<li>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'li_tree2'"></xsl:with-param>
		</xsl:call-template>
		</li>
		</ul>
		</blockquote>

		<h3><xsl:value-of select="$gIndex"></xsl:value-of></h3>
		<blockquote>
		<xsl:variable name="ilink">
			<xsl:text disable-output-escaping="yes">&lt;a href= "index-all.html"&gt;</xsl:text><xsl:value-of select="$gIndex"></xsl:value-of><xsl:text disable-output-escaping="yes">&lt;/a&gt;</xsl:text> 
		</xsl:variable>

		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'indexdoc'"></xsl:with-param>
			<xsl:with-param name="p1" select="$ilink"></xsl:with-param>
		</xsl:call-template>

		</blockquote>

		<h3><xsl:value-of select="$gPrev"></xsl:value-of><xsl:text>/</xsl:text><xsl:value-of select="$gNext"></xsl:value-of></h3>
		<blockquote>
		<xsl:call-template name="getLocalizedResource">
			<xsl:with-param name="code" select="'prev_next'"></xsl:with-param>
		</xsl:call-template>
		</blockquote>
		<br/>

		<hr/>
		<!-- NAVBAR -->
		<xsl:if test="$navbar_param">
			<xsl:call-template name="HelpNavBar"></xsl:call-template>
		</xsl:if>
		<br/>
		<p/>
		<xsl:value-of select="$bottom_param"></xsl:value-of>

</xsl:template>
</xsl:stylesheet>
